# Setup Python App di cPanel

## Cara Setup Python App di cPanel:

### 1. Buat Python App di cPanel
1. Login ke cPanel
2. Buka **"Setup Python App"** atau **"Python App"**
3. Klik **"Create Application"**

### 2. Konfigurasi Application
- **Python Version**: Pilih Python 3.11 atau yang tersedia
- **Application Root**: `/home/username/public_html/php/python`
- **Application URL**: `/php/python` (atau sesuai kebutuhan)
- **Application Startup File**: `passenger_wsgi.py`
- **Application Entry Point**: `application`

### 3. Install Dependencies
Setelah app dibuat, jalankan di Terminal cPanel:
```bash
cd ~/public_html/php/python
pip3.11 install -r requirements.txt --user
```

### 4. Restart Application
Setelah setup selesai, klik **"Restart"** di Python App manager

### 5. Update .htaccess (jika perlu)
File `.htaccess` sudah dibuat, tapi pastikan path sesuai dengan username Anda:
- Ganti `/home/username/` dengan path home directory Anda
- Path bisa dilihat di cPanel → File Manager

### 6. Test API
Setelah restart, test API dengan:
```
https://yourdomain.com/php/python/api/health
```

### Catatan Penting:
- Pastikan semua file Python ada di folder `php/python/`
- File `passenger_wsgi.py` adalah entry point untuk cPanel
- Variable `application` di `api_server.py` diperlukan untuk Passenger WSGI
- Jika masih error, cek error log di cPanel → Errors

