# Python API Server

This folder contains the Python API server for account checking functionality.

## Structure

- `api_server.py` - Main Flask API server
- `func.py` - User management and utility functions
- `api-microsoft.py` - Microsoft account checker
- `api-cpanel.py` - cPanel account checker
- `telegram_bot.py` - Telegram bot integration
- `run.py` - Script to start the API server
- `requirements.txt` - Python dependencies

## Installation

1. Install Python dependencies:
```bash
pip install -r requirements.txt
```

## Running the Server

### Option 1: Using run.py
```bash
python run.py
```

### Option 2: Direct execution
```bash
python api_server.py
```

### Option 3: With custom port
```bash
set API_PORT=5001
python run.py
```

### Option 4: Allow external connections
```bash
set API_HOST=0.0.0.0
set API_PORT=5001
python run.py
```

## Configuration

The API server URL can be configured from the PHP Admin Panel:
1. Go to Admin Panel → Settings
2. Enter Python API Server URL (e.g., `http://192.168.1.100:5001`)
3. Click "Test Connection" to verify
4. Click "Save Configuration"

## Default Port

- Default port: `5001`
- Default host: `0.0.0.0` (allows external connections)

## API Endpoints

- `GET /api/health` - Health check endpoint
- `POST /api/user/login` - User login
- `POST /api/user/login/verify` - Verify OTP
- `POST /api/check/start` - Start account checking
- `GET /api/check/status/<check_id>` - Get check status
- `GET /api/check/results/<check_id>` - Get check results
- And more...

## Important Notes

- The server can run on a different machine/server
- Configure the API URL from PHP Admin Panel
- All paths are relative to the root directory (htdocs/)
- Users folder: `../users/`
- Results folder: `../results/`
- List file: `../list.txt`

